#ifndef _LUTSTEP_H_
#define _LUTSTEP_H_

//~~~~~~~~~~~~~~~~~~~~
#include <qd_types.h>
#include <stdcolor.h>
//~~~~~~~~~~~~~~~~~~~~


//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//       Masks
//--------------------------
#define LUTEND    (1<<30)
#define NOBARS    (1<<28)
#define GRAYMINUS (1<<27)
#define RANDOMIZE (1<<26)
#define GRAYHIT   (1<<25)
#define GRAYLOW   (1<<24)
#define GRAYACE   (1<<23)
#define ANTIALIAS (1<<22)
#define GRAYEXT   (1<<21)
#define HUEIBM    (1<<20)
#define HUEPEN    (1<<19)
#define HUEMID    (1<<18)
#define HUECMY    (1<<17)
#define HUERGB    (1<<16)
#define HUEIQ     (1<<15)
#define HUEPULSE  (1<<14)
#define GRAYQTR   (1<<13)
#define GRAYPEN   (1<<12)
#define GRAYIBM   (1<<11)
#define GRAYMID   (1<<10)
#define GRAYDEC   (1<<9)
#define GRAYEND   (1<<8)
#define GRAYCON   (1<<7)
#define GRAYHEX   (1<<6)
#define GRAYPULSE (1<<5)
#define GRAYTRI   (1<<4)
#define GRAYALL   (1<<3)
#define BW        (1<<2)
#define NOGAMMA   (1<<1)
#define TOBLANK   (1<<0)
#define BLACK     0
//
//
//   Number of colors
//-----------------------
#define BWGRAYS     2
#define DECGRAYS   11
#define HEXGRAYS   16
#define TRIGRAYS   31
#define IBMGRAYS    4
#define ACEGRAYS    4
#define CONGRAYS    4
#define ENDGRAYS    2
#define MIDGRAYS    1
#define QTRGRAYS    1
#define PENGRAYS    1
#define LOWGRAYS    1
#define HITGRAYS    1
#define EXTGRAYS    8
#define RGBHUES     3
#define CMYHUES     3
#define MIDHUES     6
#define IBMHUES    12
#define PENHUES     6
#define IQHUES      4
#define PULSEGRAYS 64
#define PULSEHUES 512
#define ALLGRAYS  256
#define MINUSGRAYS  4



//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                              Color Tables
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
extern TColor *graysbw[];
extern TColor *grayshex[];
extern TColor *graysdec[];
extern TColor *grayscon[];
extern TColor *graysend[];
extern TColor *graysmid[];
extern TColor *huesrgb[];
extern TColor *huescmy[];
extern TColor *huesmid[];
extern TColor *huespen[];
extern TColor *huesibm[];
extern TColor *graysibm[];
extern TColor *graysace[];
extern TColor *grayspen[];
extern TColor *grayslow[];
extern TColor *grayshit[];
extern TColor *graysqtr[];
extern TColor *graystri[];
extern TColor *graysext[];
extern TColor *huesiq[];
extern TColor *graysminus[];

extern TColor graypulse[];
extern TColor huepulse[];

extern TColor grayscale;



#endif // _LUTSTEP_H_
